
import serial
import os
import time
from logo import *


def cls():
	os.system('cls' if os.name == 'nt' else 'clear')

cls()
RFM()
time.sleep(2)
while True:
	try:
		VICIport = int(input("Port number of VICI valve: "))
		if VICIport >= 0:
			cls()
			RFM()
			print("Port: COM" + str(VICIport))
			break
		else:
			cls()
			RFM()
			print("Port must be an integer")
			continue
	except ValueError:
		cls()
		RFM()
		print("Port must be an integer")
		continue

ser = serial.Serial(
	port = "COM" + str(VICIport),
	baudrate = 9600,
	parity = serial.PARITY_NONE,
	stopbits = serial.STOPBITS_ONE,
	bytesize = serial.EIGHTBITS,
        
        
)

SwitchBothA = [int(0x2A)] + [int(0x63)] + [int(0x77)] + [int(0x0D)]

SwitchB = [int(0x33)] + [int(0x63)] + [int(0x63)] + [int(0x0D)]

SwitchA = [int(0x33)] + [int(0x63)] + [int(0x77)] + [int(0x0D)]

while True:
	try:
		FirstWait = int(input("Time until first switch (seconds): "))
		if FirstWait >= 0:
			cls()
			RFM()
			print("Port: COM" + str(VICIport))
			print("Initial wait: " + str(FirstWait) + " seconds")
			break
		else:
			cls()
			RFM()
			print("Port: COM" + str(VICIport))
			print("Time must be a positive integer")
			continue
	except ValueError:
		cls()
		RFM()
		print("Port: COM" + str(VICIport))
		print("Time must be a positive integer")
		continue

while True:
	try:
		IntervalTime = int(input("Interval between valve switching (seconds): "))
		if IntervalTime >= 0:
			cls()
			RFM()
			print("Port: COM" + str(VICIport))
			print("Initial wait: " + str(FirstWait) + " seconds")
			print("Interval: " + str(IntervalTime) + " seconds")
			break
		else:
			cls()
			RFM()
			print("Port: COM" + str(VICIport))
			print("Initial wait: " + str(FirstWait) + " seconds")
			print("Time must be a positive integer")
			continue
	except ValueError:
		cls()
		RFM()
		print("Port: COM" + str(VICIport))
		print("Initial wait: " + str(FirstWait) + " seconds")
		print("Time must be a positive integer")
		continue

while True:
	try:
		SecondIntervalTime = int(input("Interval between second valve switch (seconds): "))
		if IntervalTime >= 0:
			cls()
			RFM()
			print("Port: COM" + str(VICIport))
			print("Initial wait: " + str(FirstWait) + " seconds")
			print("Interval: " + str(IntervalTime) + " seconds")
			print("Second interval: " + str(SecondIntervalTime) + " seoonds")
			break
		else:
			cls()
			RFM()
			print("Port: COM" + str(VICIport))
			print("Initial wait: " + str(FirstWait) + " seconds")
			print("Time must be a positive integer")
			continue
	except ValueError:
		cls()
		RFM()
		print("Port: COM" + str(VICIport))
		print("Initial wait: " + str(FirstWait) + " seconds")
		print("Time must be a positive integer")
		continue

while True:
	try:
		ReactionTime = int(input("Total reaction time (seconds): "))
		if FirstWait >= 0:
			cls()
			RFM()
			print("Port: COM" + str(VICIport))
			print("Initial wait: " + str(FirstWait) + " seconds")
			print("Interval: " + str(IntervalTime) + " seconds")
			print("Second interval: " + str(SecondIntervalTime) + " seoonds")
			print("Total reaction time: " + str(ReactionTime) + " seconds")
			break
		else:
			cls()
			RFM()
			print("Port: COM" + str(VICIport))
			print("Initial wait: " + str(FirstWait) + " seconds")
			print("Interval: " + str(IntervalTime) + " seconds")
			print("Second interval: " + str(SecondIntervalTime) + " seoonds")
			print("Time must be a positive integer")
			continue
	except ValueError:
		cls()
		RFM()
		print("Port: COM" + str(VICIport))
		print("Initial wait: " + str(FirstWait) + " seconds")
		print("Interval: " + str(IntervalTime) + " seconds")
		print("Second interval: " + str(SecondIntervalTime) + " seoonds")
		print("Time must be a positive integer")
		continue



MaxTime = (ReactionTime-FirstWait)/(IntervalTime+SecondIntervalTime)

ser.isOpen()

time.sleep(FirstWait)

ser.write(SwitchBothA)

for x in range(0,int(round(MaxTime))):
    
	time.sleep(IntervalTime)
	
	ser.write(SwitchB)

	time.sleep(SecondIntervalTime)

	ser.write(SwitchA)


ser.close()

